



export class ContractTypeListWidget {
	
	container = null;
	ctypes = null;
	
	ezTpl = null;
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
				<a href="{{appUrl('/masterdata/contracts/types/edit/')}}" class="fa fa-plus"></a>
			</div>
			
			<h1>Contract types</h1>
		</div>
		
		<div ez-if="ctypes == null">
			Loading...
		</div>
		<div ez-if="ctypes != null">
			<table class="table">
				<thead>
					<tr>
						<th></th>
						<th>Naam</th>
						<th></th>
					</tr>
				</thead>
				<tbody  ez-for="ctypes" ez-item="ct" class="tbody-ctypes">
					<tr [onclick]="widget.editType" class="pointer">
						<td class="sort-cell" style="width: 20px;"><i class="fa fa-bars sort-handle"></i></td>
						<td contract-type-id="{{ct.contractTypeId}}">
							{{ct.name}}
						</td>
						<td class="actions">
							<a href="{{appUrl('/masterdata/contracts/type/edit/?id='+ct.contractTypeId)}}" class="fa fa-pencil"></a>
						</td>
					</tr>
				</tbody>
					
				<tbody ez-if="ctypes.length == 0">
					<tr>
						<td colspan="3" class="no-results">
							Geen resultaten gevonden
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	`;
	
	
	editType(evt, tr) {
		let target = evt.target;
		
		if ($(target).hasClass('sort-cell') || $(target).closest('.sort-cell').length > 0)
			return;
		
		let ctid = tr.querySelector('td[contract-type-id]').getAttribute('contract-type-id');
		
		gotoRoute( '/masterdata/contracts/types/edit/?id='+ctid );
	}


	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('ctypes', this.ctypes);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();

		$(this.container).find('.tbody-ctypes').sortable({
			handle: '.sort-handle',
			update: function() {
				this.saveSort();
			}.bind(this)
		});
		
	}
	
	saveSort() {
		let ids = [];
		$('.tbody-ctypes tr').each(function(index, node) {
			let id = $(node).find('td[contract-type-id]').attr('contract-type-id');
			ids.push(id);
		});
		
		postUrl( '/service/contracts/type.do', {
			a: 'updateSort',
			ids: ids.join(',')
		}).then(() => {
			showToastMessage( 'Volgorde opgeslagen' );
		});
	}
	
	
	loadContractTypes() {
		postUrl( '/service/contracts/type.do')
		.then(async function(e) {
			let json = await e.json();
			if (json.error) {
				showErrorWidget( json );
				return;
			}
			
			this.ctypes = json.contractTypes;
			this.render();
			
		}.bind(this));
	}
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		this.loadContractTypes();
	}

}

